//=============================================================================
// TestBlock, Deployed.
//=============================================================================
class TNTBlockDeployed extends BlockDeployed;

var bool bLit, bFlash;
var float FuseTime;
var int FuseCount;

auto state Active
{

function TakeDamage(int i, Pawn P, vector V, Vector M, Name N)
{
 bLit = True;
 
 Super.TakeDamage(i, P, V, M, N);
}

}

function UpdateBlock()
{
 local int i, NumCharge;
 
 Super.UpdateBlock();
 
 for(i=0; i<6; i++)
 {
  if (CurNeighbors[i] != None && CurNeighbors[i].bHasCharge)
  {
   NumCharge++;
  }
 }
 
 if (bLit)
 {
  FuseCount++;
  FuseTime -= 0.1;
 }
 
 if(!bLit && NumCharge > 0) bLit = True;
 
 if (bLit && FuseCount >= 5)
 {
  FuseCount = 0;
  
  bHasGravity = True;
  bUnlit = False;
  
  bFlash = !bFlash;
  
  ScaleGlow = 1000 * int(bFlash);
 }
 
 if (FuseTime <= 0)
 {
  bInvincible = False;
  Explode(Location);
 }
}

function Frob(Actor F, Inventory I)
{
 if (!bLit)
 {
  Super.Frob(F, I);
 }
}

defaultproperties
{
     LightType=LT_Steady
     LightBrightness=64
     LightSaturation=255
     LightRadius=0
     LightPeriod=32
     LightCone=128
     VolumeBrightness=64
     
     FuseTime=5.000000
     ExplosionRadius=256
     ExplosionDamage=150
     bInvincible=False
}
